/* Arvore de Lindenmeier
 * 
 * Autor: Carlos Henrique Q. Forster
 * Instituto Tecnologico de Aeronautica
 * Curso de CES-10 Introducao a Computacao
 */
 
#include <graphics.h>
#include <stdio.h>
#include <stdlib.h>
#include <math.h>


void start_graphics()
{
   initwindow(640,480);
}


double dx=0, dy=-1.0;
double x=100, y=100;

void ponto()
{
  line(x+dx*5,y+dy*5,x-dy*5,y+dx*5);
  line(x+dx*5,y+dy*5,x+dy*5,y-dx*5);
}

void direita(double angle)
{
  double ndx,ndy;
  angle*=3.1416/180.0;
  ndx=dx*cos(angle)+dy*sin(angle);
  ndy=-dx*sin(angle)+dy*cos(angle);
  dx=ndx;
  dy=ndy;
}

void esquerda(double angle)
{
  direita(-angle);
}

void frente(double espaco)
{
  line(x,y,x+espaco*dx,y+espaco*dy);
  x+=(espaco*dx);
  y+=(espaco*dy);
}

void tree(double espaco, int n)
{
  double sx,sy,sdx,sdy;
  if(n==0) frente(espaco);
  else{
	 frente(espaco/3);
	 sx=x; sy=y; sdx=dx; sdy=dy;

	 esquerda(10);
	 tree(0.6*espaco,n-1);
	 x=sx;y=sy;dx=sdx;dy=sdy;

	 esquerda(40);
	 tree(0.6*espaco,n-1);
	 x=sx;y=sy;dx=sdx;dy=sdy;

	 direita(60);
	 tree(0.4*espaco,n-1);
	 x=sx;y=sy;dx=sdx;dy=sdy;
  }
}


main()
{
  start_graphics();

  setbkcolor(DARKGRAY);
  cleardevice();

  setcolor(LIGHTCYAN);
  setlinestyle(SOLID_LINE,0,NORM_WIDTH);

  x=400;
  y=400;

  ponto();
  tree(380,7);

  getchar();
  closegraph();
}

