/* Triangulo de Sierpinski
 * 
 * Autor: Carlos Henrique Q. Forster
 * Instituto Tecnologico de Aeronautica
 * Curso de CES-10 Introducao a Computacao
 */
 
#include <graphics.h>
#include <stdio.h>
#include <stdlib.h>
#include <math.h>

void start_graphics()
{
   initwindow(640,480);
}



void sierpinski(int x0,int y0, int x1, int y1, int x2, int y2, int n)
{
  if(n==0)
  {
    line(x0,y0,x1,y1);
    line(x1,y1,x2,y2);
    line(x0,y0,x2,y2);
  }
  else
  {
    sierpinski(x0,y0,(x1+x0)/2,(y1+y0)/2,(x2+x0)/2,(y2+y0)/2,n-1);
    sierpinski((x1+x0)/2,(y1+y0)/2,x1,y1,(x2+x1)/2,(y2+y1)/2,n-1);
    sierpinski((x2+x0)/2,(y2+y0)/2,(x2+x1)/2,(y2+y1)/2,x2,y2,n-1);
  }
}

main()
{
  start_graphics();

  setbkcolor(DARKGRAY);
  cleardevice();

  setcolor(YELLOW);
  setlinestyle(SOLID_LINE,0,NORM_WIDTH);
  
  sierpinski(630,400,320,10,10,400,5);

  getchar();

  closegraph();
}

