/* Curva de Koch
 * 
 * Autor: Carlos Henrique Q. Forster
 * Instituto Tecnologico de Aeronautica
 * Curso de CES-10 Introducao a Computacao
 */
 
#include <graphics.h>
#include <stdio.h>
#include <stdlib.h>
#include <math.h>

double dx=0, dy=-1.0;
double x=100, y=100;

void start_graphics()
{
   initwindow(640,480);
}


void ponto()
{
  line(x+dx*5,y+dy*5,x-dy*5,y+dx*5);
  line(x+dx*5,y+dy*5,x+dy*5,y-dx*5);
}

void direita(double angle)
{
  double ndx,ndy;
  angle*=3.1416/180.0;
  ndx=dx*cos(angle)+dy*sin(angle);
  ndy=-dx*sin(angle)+dy*cos(angle);
  dx=ndx;
  dy=ndy;
}

void esquerda(double angle)
{
  direita(-angle);
}

void frente(double espaco)
{
  line(x,y,x+espaco*dx,y+espaco*dy);
  x+=(espaco*dx);
  y+=(espaco*dy); 
}

void koch(double espaco, int n)
{
  if(n==0) frente(espaco);
  else{
    koch(espaco/3.0,n-1);
    esquerda(60);
    koch(espaco/3.0,n-1);
    direita(120);
    koch(espaco/3.0,n-1);
    esquerda(60);
    koch(espaco/3.0,n-1);
  }
}
  
void rkoch(double espaco, int n)
{
  double ang;
  if(n==0) frente(espaco);
  else{
    if(rand()%2==1)ang=-1; else ang=1;
    rkoch(espaco/3.0,n-1);
    esquerda(60*ang);
    rkoch(espaco/3.0,n-1);
    direita(120*ang);
    rkoch(espaco/3.0,n-1);
    esquerda(60*ang);
    rkoch(espaco/3.0,n-1);
  }
}



main()
{
  start_graphics();

  setbkcolor(DARKGRAY);
  cleardevice();

  setcolor(LIGHTCYAN);
  setlinestyle(SOLID_LINE,0,NORM_WIDTH);
  
  srand(timeGetTime());
  
  x=400;
  y=400;
  
  ponto();
    koch(380,7); direita(120);
    koch(380,7); direita(120);
    koch(380,7); direita(120);

  getchar();
  closegraph();
}

