/* Spacefilling curve de Hilbert
 * 
 * Autor: Carlos Henrique Q. Forster
 * Instituto Tecnologico de Aeronautica
 * Curso de CES-10 Introducao a Computacao
 */
 
#include <graphics.h>
#include <stdio.h>
#include <stdlib.h>
#include <math.h>

int dx=0, dy=-1;
int x=100, y=100;

void start_graphics()
{
   initwindow(640,480);
}


void ponto()
{
  line(x+dx*5,y+dy*5,x-dy*5,y+dx*5);
  line(x+dx*5,y+dy*5,x+dy*5,y-dx*5);
}

void direita()
{
  int ndx,ndy;
  ndx=-dy;
  ndy=dx;
  dx=ndx;
  dy=ndy;
}

void esquerda()
{
  int ndx,ndy;
  ndx=dy;
  ndy=-dx;
  dx=ndx;
  dy=ndy;
}

void frente(int espaco)
{
  line(x,y,x+espaco*dx,y+espaco*dy);
  x+=(espaco*dx);
  y+=(espaco*dy); Sleep(4*espaco);
}

void hilbert(int n, int espaco)
{
  void rhilbert(int n, int espaco);
  if(n==0) direita();
  else
  {
    direita();
    rhilbert(n-1,espaco/2);
    frente(espaco/2);
    hilbert(n-1,espaco/2);
    frente(espaco/2);
    esquerda();
    hilbert(n-1,espaco/2);
    direita();
    frente(espaco/2);
    direita();
    rhilbert(n-1,espaco/2);
    esquerda();
  }
}

void rhilbert(int n, int espaco)
{
  if(n==0) esquerda();
  else
  {
    esquerda();
    hilbert(n-1,espaco/2);
    frente(espaco/2);
    rhilbert(n-1,espaco/2);
    frente(espaco/2);
    direita();
    rhilbert(n-1,espaco/2);
    esquerda();
    frente(espaco/2);
    esquerda();
    hilbert(n-1,espaco/2);
    direita();
  }
}


main()
{
  start_graphics();

  setbkcolor(DARKGRAY);
  cleardevice();

  setcolor(LIGHTGREEN);
  setlinestyle(SOLID_LINE,0,NORM_WIDTH);
  
  x=100;
  y=300;

  ponto();
  hilbert(8,100); ponto();

  getchar();

  closegraph();
}

