/* Plotador de funcoes ilustrativo
 * 
 * Autor: Carlos Henrique Q. Forster
 * Instituto Tecnologico de Aeronautica
 * Curso de CES-10 Introducao a Computacao
 */
 
#include <graphics.h>
#include <stdio.h>
#include <conio.h>
#include <stdlib.h>
#include <math.h>

void start_graphics()
{
   initwindow(640,480);
}


struct dados { float valor; int cor; char texto[20];};

struct dados v[5]={{250.0,YELLOW,"Amarelo"},
						 {150.0,GREEN,"Verde"},
						 {60.0,LIGHTGREEN,"Verde Claro"},
						 {120.0,BLUE,"Azul"},
						 {85.0,MAGENTA,"Magenta"}};

float soma=0.0, angini, angfin;

double f(double x)
{
  return 40*sin(x)/(x*x+1.0);
}

main()
{
  int x, y, i;

  start_graphics();

  setbkcolor(DARKGRAY);
  cleardevice();

  setcolor(RED);
  rectangle(100,100,540,380);

  setlinestyle(DOTTED_LINE,0,NORM_WIDTH);
  for (x=150; x<540; x+=50) line(x,100,x,380);
  for (y=150; y<380; y+=50) line(100,y,540,y);

  setlinestyle(SOLID_LINE,0,NORM_WIDTH);
  settextstyle(TRIPLEX_FONT,HORIZ_DIR,2);
  y=110;

  for(i=0; i<5; i++) soma+=v[i].valor;

  angini=0;
  setlinestyle(SOLID_LINE,0,NORM_WIDTH);
  setcolor(GREEN);
  for(x=100; x<539; x+=1)
  {
	 line(x,10*f((x-320)/10.0)+200,x+1,10*f((x-320+1)/10.0)+200);
  };

  getchar();

  closegraph();
}
